# Create a File Template

File Templates are applied when creating a new file or generating code, and can contain includes. 

### Customize Code Generation

1. Open the Settings Pane and navigate to _Editor | File and Code Templates_.
2. Under _includes_, edit the _PHP File Header_ include so that it matches your preference. Save the changes.
3. Create a new file in the current folder. _Alt+Insert (Command+N)_ and generate a new _PHP class_ in the current folder.
   The header for this file should reflect the changes we have just made.
4. Create a new file template for creating Smarty pages:

```
<?php
#parse("PHP File Header.php")

require dirname(__FILE__) . '/../libs/Smarty.class.php';

\$smarty = new Smarty();
\$smarty->assign('title', '${Title}', true);
\$smarty->display('${TemplateName}.tpl');
```

5. Test the new file template. Note that the variables defined in the template can be provided through the New File dialog.